#!/usr/bin/env bash
set -euo pipefail
# Recreate H23 with the included manifest; choose a fresh UTC timestamp for the outdir.
TS=$(date -u +"%Y-%m-%dT%H-%M-%SZ")
OUTDIR="runs/$TS"
mkdir -p "$OUTDIR"
python3 engine_h23_molecular_cohesion.py --manifest config/manifest_h23.json --outdir "$OUTDIR"
echo "Done. See $OUTDIR/outputs for metrics and audit."
